//	Altirra - Atari 800/800XL emulator
//	Copyright (C) 2008 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef AT_KSYMS_H
#define AT_KSYMS_H

namespace ATKernelSymbols {
	// page zero
	enum {
		WARMST = 0x0008,
		DOSVEC = 0x000A,
		DOSINI = 0x000C,
		POKMSK = 0x0010,
		BRKKEY = 0x0011,
		RTCLOK = 0x0012,
		ICDNOZ = 0x0021,
		ICBALZ = 0x0024,
		ICBAHZ = 0x0025,
		ICAX1Z = 0x002A,
		ICAX2Z = 0x002B,
		CHKSUM = 0X0031,
		BUFRLO = 0X0032,
		BUFRHI = 0X0033,
		BFENLO = 0X0034,
		BFENHI = 0X0035,
		BUFRFL = 0X0038,
		CHKSNT = 0x003B,
		CRITIC = 0x0042,
		ATRACT = 0x004D,
		DRKMSK = 0x004E,
		COLRSH = 0x004F,
		RAMLO  = 0x0085,
		FR0	   = 0x00D4,
		FR1    = 0x00E0,
		CIX    = 0x00F2,
		INBUFF = 0x00F3,
		FLPTR  = 0x00FC
	};

	// page 2/3 symbols
	enum {
		VDSLST = 0x0200,
		VPRCED = 0x0202,
		VINTER = 0x0204,
		VBREAK = 0x0206,
		VKEYBD = 0x0208,
		VSERIN = 0x020A,
		VSEROR = 0x020C,
		VSEROC = 0x020E,
		VTIMR1 = 0x0210,
		VTIMR2 = 0x0212,
		VTIMR4 = 0x0214,
		VIMIRQ = 0x0216,
		CDTMV1 = 0x0218,
		CDTMV2 = 0x021A,
		CDTMV3 = 0x021C,
		CDTMV4 = 0x021E,
		CDTMV5 = 0x0220,
		VVBLKI = 0x0222,
		VVBLKD = 0x0224,
		CDTMA1 = 0x0226,
		CDTMA2 = 0x0228,
		CDTMF3 = 0x022A,
		CDTMF4 = 0x022C,
		CDTMF5 = 0x022E,
		SDMCTL = 0x022F,
		SDLSTL = 0x0230,
		SDLSTH = 0x0231,
		COLDST = 0x0244,
		GPRIOR = 0x026F,
		JVECK  = 0x028C,
		PCOLR0 = 0x02C0,
		PCOLR1 = 0x02C1,
		PCOLR2 = 0x02C2,
		PCOLR3 = 0x02C3,
		COLOR0 = 0x02C4,
		COLOR1 = 0x02C5,
		COLOR2 = 0x02C6,
		COLOR3 = 0x02C7,
		COLOR4 = 0x02C8,
		MEMTOP = 0x02E5,
		MEMLO  = 0x02E7,
		CHACT  = 0x02F3,
		CHBAS  = 0x02F4,
		DDEVIC = 0x0300,
		DUNIT  = 0x0301,
		HATABS = 0x031A,
		ICCMD  = 0x0342,
		ICSTA  = 0x0343,
		ICBAL  = 0x0344,
		LBUFF  = 0x0580
	};

	// hardware symbols
	enum {
		COLPM0 = 0xD012,
		COLPM1 = 0xD013,
		COLPM2 = 0xD014,
		COLPM3 = 0xD015,
		COLPF0 = 0xD016,
		COLPF1 = 0xD017,
		COLPF2 = 0xD018,
		COLPF3 = 0xD019,
		COLBK  = 0xD01A,
		PRIOR  = 0xD01B,
		CONSOL = 0xD01F,
		IRQST  = 0xD20E,
		IRQEN  = 0xD20E,
		DMACTL = 0xD400,
		CHACTL = 0xD401,
		DLISTL = 0xD402,
		DLISTH = 0xD403,
		CHBASE = 0xD409,
		NMIEN  = 0xD40E,
		NMIRES = 0xD40F,
	};

	// floating-point library symbols
	enum {
		AFP    = 0xD800,
		FASC   = 0xD8E6,
		IPF    = 0xD9AA,
		FPI    = 0xD9D2,	// __ftol
		ZFR0   = 0xDA44,
		ZF1    = 0xDA46,
		LDBUFA = 0xDA51,	// undocumented (used by Atari Basic) - mwa #ldbuf inbuff
		FADD   = 0xDA66,
		FSUB   = 0xDA60,
		FMUL   = 0xDADB,
		FDIV   = 0xDB28,
		SKPSPC = 0xDBA1,	// undocumented (used by Atari Basic) - skip spaces starting at INBUFF[CIX]
		ISDIGT = 0xDBAF,	// undocumented (used by Atari Basic) - set carry if INBUFF[CIX] is not a digit
		PLYEVL = 0xDD40,
		FLD0R  = 0xDD89,
		FLD0P  = 0xDD8D,
		FLD1R  = 0xDD98,
		FLD1P  = 0xDD9C,
		FST0R  = 0xDDA7,
		FST0P  = 0xDDAB,
		FMOVE  = 0xDDB6,
		EXP    = 0xDDC0,
		EXP10  = 0xDDCC,
		LOG    = 0xDECD,
		LOG10  = 0xDED1
	};

	// kernel symbols
	enum {
		DSKINV = 0xE453,
		CIOV   = 0xE456,
		SIOV   = 0xE459,
		SYSVBV = 0xE45F,
		XITVBV = 0xE462
	};
}


#endif
